
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("scarf_and_toque_production")

# Create variables
scarfs = m.addVar(lb=0, vtype=GRB.INTEGER, name="scarfs")
toques = m.addVar(lb=0, vtype=GRB.INTEGER, name="toques")

# Set objective function
m.setObjective(20 * scarfs + 25 * toques, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * scarfs + 30 * toques <= 250000, "time_constraint")
m.addConstr(scarfs >= 5000, "scarf_min")
m.addConstr(toques >= 3000, "toque_min")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of scarfs to produce: {scarfs.x}")
    print(f"Number of toques to produce: {toques.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

