
from gurobipy import *

# Create a model
m = Model("Knitting_Factory")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="scarfs")
x2 = m.addVar(vtype=GRB.INTEGER, name="toques")

# Set objective function
m.setObjective(20*x1 + 25*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 30*x2 <= 250000, "knitting_time")
m.addConstr(x1 >= 5000, "min_scarfs")
m.addConstr(x2 >= 3000, "min_toques")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of scarfs: {x1.x}")
    print(f"Number of toques: {x2.x}")
    print(f"Maximum profit: ${20*x1.x + 25*x2.x}")
else:
    print("No optimal solution found")
