
import gurobipy as gp

# Create a new model
model = gp.Model("Scarfs_and_Toques")

# Define the variables
x1 = model.addVar(name="scarfs", lb=0, vtype=gp.GRB.INTEGER)  # Number of scarfs
x2 = model.addVar(name="toques", lb=0, vtype=gp.GRB.INTEGER)  # Number of toques

# Objective function: Maximize profit
model.setObjective(20*x1 + 25*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(20*x1 + 30*x2 <= 250000, name="knitting_minutes")
model.addConstr(x1 >= 5000, name="min_scarfs")
model.addConstr(x2 >= 3000, name="min_toques")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {model.x[0]} scarfs, {model.x[1]} toques")
    print(f"Max profit: ${20*model.x[0] + 25*model.x[1]}")
else:
    print("No optimal solution found")
