
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Coat Production")

# Create variables
north_hours = m.addVar(lb=0, name="north_hours")  # Hours running north factory
south_hours = m.addVar(lb=0, name="south_hours")  # Hours running south factory


# Set objective function: Minimize total cost
m.setObjective(200 * north_hours + 400 * south_hours, GRB.MINIMIZE)

# Add constraints: Production must meet demand
m.addConstr(20 * north_hours + 30 * south_hours >= 75, "Long Coats Demand")
m.addConstr(15 * north_hours + 25 * south_hours >= 30, "Short Coats Demand")
m.addConstr(10 * north_hours + 30 * south_hours >= 40, "Mini Coats Demand")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${m.objVal:.2f}")
    print(f"North Factory Hours: {north_hours.x:.2f}")
    print(f"South Factory Hours: {south_hours.x:.2f}")

elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

