
from gurobipy import *

# Create a new model
m = Model("Tom_Designs_Production")

# Define variables
x1 = m.addVar(name='x1', lb=0)  # Hours north factory runs
x2 = m.addVar(name='x2', lb=0)  # Hours south factory runs

# Set the objective function
m.setObjective(200*x1 + 400*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(20*x1 + 30*x2 >= 75, name='long_coats')
m.addConstr(15*x1 + 25*x2 >= 30, name='short_coats')
m.addConstr(10*x1 + 30*x2 >= 40, name='mini_coats')

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. North factory runs for {x1.x} hours, south factory runs for {x2.x} hours.")
    print(f"Total cost: ${200*x1.x + 400*x2.x}")
else:
    print("No optimal solution found")
