
import gurobi

def solve_production_planning_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0, ub=gurobi.GRB.INFINITY, obj=200)
    x2 = model.addVar(name="x2", lb=0, ub=gurobi.GRB.INFINITY, obj=400)

    # Add constraints
    model.addConstr(20*x1 + 30*x2 >= 75, name="long_coats")
    model.addConstr(15*x1 + 25*x2 >= 30, name="short_coats")
    model.addConstr(10*x1 + 30*x2 >= 40, name="mini_coats")

    # Set the objective function
    model.setObjective(200*x1 + 400*x2, gurobi.GRB.MINIMIZE)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours at north factory: {x1.x}")
        print(f"Hours at south factory: {x2.x}")
        print(f"Total cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_production_planning_problem()
