
from gurobipy import Model, GRB

# Create a new model
model = Model("smoothie_optimization")

# Create variables
apple_smoothies = model.addVar(vtype=GRB.CONTINUOUS, name="apple_smoothies")
orange_smoothies = model.addVar(vtype=GRB.CONTINUOUS, name="orange_smoothies")


# Set objective function
model.setObjective(3.5 * apple_smoothies + 4.5 * orange_smoothies, GRB.MAXIMIZE)

# Add constraints
model.addConstr(6 * apple_smoothies + 5 * orange_smoothies <= 500, "cutting_machine_constraint")
model.addConstr(3 * apple_smoothies + 2 * orange_smoothies <= 500, "blending_machine_constraint")
model.addConstr(apple_smoothies >=0)
model.addConstr(orange_smoothies >=0)



# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"Apple smoothies: {apple_smoothies.x:.2f}")
    print(f"Orange smoothies: {orange_smoothies.x:.2f}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

