
from gurobipy import *

# Create a model
m = Model("Smoothie_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apple_smoothies")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="orange_smoothies")

# Set objective function
m.setObjective(3.5*x1 + 4.5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x1 + 5*x2 <= 500, "cutting_machine_time")
m.addConstr(3*x1 + 2*x2 <= 500, "blending_machine_time")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of apple smoothies: {x1.x}")
    print(f"Number of orange smoothies: {x2.x}")
    print(f"Maximum profit: ${3.5*x1.x + 4.5*x2.x:.2f}")
else:
    print("No optimal solution found")
