
import gurobi

def solve_smoothie_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="apple_smoothies", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="orange_smoothies", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize 3.5*x1 + 4.5*x2
    model.setObjective(3.5 * x1 + 4.5 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6 * x1 + 5 * x2 <= 500, name="cutting_machine_constraint")
    model.addConstr(3 * x1 + 2 * x2 <= 500, name="blending_machine_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_smoothie_problem()
