
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("medicine_cost")

# Create variables
klun = m.addVar(lb=0, name="klun")  # Number of Klun pills
tao = m.addVar(lb=0, name="tao")  # Number of Tao pills

# Set objective function: Minimize total cost
m.setObjective(2.6 * klun + 3.2 * tao, GRB.MINIMIZE)

# Add constraints:
# AX7 requirement
m.addConstr(1.5 * klun + 1.3 * tao >= 6, "AX7_req")

# BY5 requirement
m.addConstr(1.8 * klun + 2 * tao >= 8, "BY5_req")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Number of Klun pills: {klun.x:.2f}")
    print(f"Number of Tao pills: {tao.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

