
from gurobipy import *

# Create a new model
m = Model("Emma_Medicine_Problem")

# Define variables
x1 = m.addVar(name='Klun_pills', vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name='Tao_pills', vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(2.6*x1 + 3.2*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(1.5*x1 + 1.3*x2 >= 6, name='AX7_requirement')
m.addConstr(1.8*x1 + 2*x2 >= 8, name='BY5_requirement')

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {m.objVal} dollars")
    print(f"Klun pills: {x1.x}, Tao pills: {x2.x}")
else:
    print("No optimal solution found")

