
import gurobi

def solve_medicine_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="Klun_pills", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="Tao_pills", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(2.6 * x1 + 3.2 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(1.5 * x1 + 1.3 * x2 >= 6, name="AX7_requirement")
    model.addConstr(1.8 * x1 + 2 * x2 >= 8, name="BY5_requirement")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of Klun pills: {x1.varValue}")
        print(f"Number of Tao pills: {x2.varValue}")
        print(f"Total cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_medicine_problem()
