
from gurobipy import Model, GRB

# Create a new model
m = Model("concert_optimization")

# Create variables
premium_seats = m.addVar(vtype=GRB.INTEGER, name="premium_seats")
regular_seats = m.addVar(vtype=GRB.INTEGER, name="regular_seats")

# Set objective function
m.setObjective(150 * premium_seats + 50 * regular_seats, GRB.MAXIMIZE)

# Add constraints
m.addConstr(premium_seats + regular_seats <= 300, "total_seats")
m.addConstr(premium_seats >= 50, "min_premium")
m.addConstr(regular_seats >= 3 * premium_seats, "regular_preference")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    print('Premium Seats:', premium_seats.x)
    print('Regular Seats:', regular_seats.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status:', m.status)

