
from gurobipy import *

# Create a model
m = Model("Concert_Seats")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="premium_seats")
x2 = m.addVar(vtype=GRB.INTEGER, name="regular_seats")

# Set the objective function
m.setObjective(150*x1 + 50*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 300, "total_seats")
m.addConstr(x1 >= 50, "premium_min")
m.addConstr(x2 >= 3*x1, "regular_preferred")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Premium seats: {x1.x}")
    print(f"Regular seats: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
