
import gurobi

def solve_concert_seating_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="premium_seats", lb=0, ub=300, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="regular_seats", lb=0, ub=300, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize 150*x1 + 50*x2
    model.setObjective(150*x1 + 50*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 300, name="total_seats")
    model.addConstr(x1 >= 50, name="min_premium_seats")
    model.addConstr(x2 >= 3*x1, name="regular_vs_premium")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Maximum profit: ${model.objVal:.2f}")
        print(f"Number of premium seats to sell: {x1.x:.0f}")
        print(f"Number of regular seats to sell: {x2.x:.0f}")
    else:
        print("No optimal solution found.")

solve_concert_seating_problem()
