
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("electronics_store")

# Create variables
headsets = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="headsets")
keyboards = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="keyboards")


# Set objective function
m.setObjective(80*headsets + 50*keyboards, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2.5*headsets + 1.5*keyboards <= 200, "space_constraint")
m.addConstr(keyboards >= 0.7*(headsets + keyboards), "keyboard_ratio_constraint")
m.addConstr(200*headsets + 110*keyboards <= 10000, "budget_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of headsets: {headsets.x:.2f}")
    print(f"Number of keyboards: {keyboards.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

