
import gurobi

def solve_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="headsets", vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(lb=0, name="keyboards", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(80*x1 + 50*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2.5*x1 + 1.5*x2 <= 200, name="floor_space")
    model.addConstr(0.3*x2 - 0.7*x1 >= 0, name="keyboard_percentage")
    model.addConstr(200*x1 + 110*x2 <= 10000, name="budget")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Headsets: {x1.varValue}")
        print(f"Keyboards: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_problem()
