
import gurobipy as gp

# Create a new model
m = gp.Model("sandwich_optimization")

# Create variables
large_sandwiches = m.addVar(vtype=gp.GRB.CONTINUOUS, name="large_sandwiches")  # Number of large sandwiches
small_sandwiches = m.addVar(vtype=gp.GRB.CONTINUOUS, name="small_sandwiches")  # Number of small sandwiches


# Set objective function
m.setObjective(5 * large_sandwiches + 3.5 * small_sandwiches, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * large_sandwiches + 3 * small_sandwiches <= 1000, "preparation_time")
m.addConstr(5 * large_sandwiches + 4 * small_sandwiches <= 1200, "toasting_time")
m.addConstr(large_sandwiches >= 0, "large_sandwiches_nonnegative")  # Ensure non-negative number of sandwiches.
m.addConstr(small_sandwiches >= 0, "small_sandwiches_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of large sandwiches: {large_sandwiches.x}")
    print(f"Number of small sandwiches: {small_sandwiches.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

