
from gurobipy import *

# Create a new model
m = Model("Sandwich_Problem")

# Define variables
x1 = m.addVar(name="large_sandwiches", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="small_sandwiches", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(5*x1 + 3.50*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 + 3*x2 <= 1000, name="preparation_time")
m.addConstr(5*x1 + 4*x2 <= 1200, name="toasting_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of large sandwiches: {x1.x}")
    print(f"Number of small sandwiches: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
