
import gurobipy as gp

# Create a new model
model = gp.Model("sandwich_store")

# Define variables
x1 = model.addVar(name="large_sandwiches", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="small_sandwiches", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: Maximize 5*x1 + 3.5*x2
model.setObjective(5*x1 + 3.5*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(4*x1 + 3*x2 <= 1000, name="preparation_time")
model.addConstr(5*x1 + 4*x2 <= 1200, name="toasting_time")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: large sandwiches = {x1.varValue}, small sandwiches = {x2.varValue}")
    print(f"Maximal profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
