
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("electronics_store")

# Create variables
televisions = m.addVar(vtype=GRB.INTEGER, name="televisions")
speakers = m.addVar(vtype=GRB.INTEGER, name="speakers")

# Set objective function
m.setObjective(400 * televisions + 250 * speakers, GRB.MAXIMIZE)

# Add constraints
m.addConstr(400 * televisions + 200 * speakers <= 25000, "budget_constraint")
m.addConstr(televisions >= 20, "min_televisions")
m.addConstr(televisions <= 75, "max_televisions")
m.addConstr(speakers <= 0.5 * televisions, "speaker_limit")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of televisions to buy and sell: {televisions.x}")
    print(f"Number of speakers to buy and sell: {speakers.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

