
from gurobipy import *

# Create a new model
m = Model("Electronics_Store")

# Define variables
x1 = m.addVar(name='x1', lb=20, ub=75, vtype=GRB.INTEGER)
x2 = m.addVar(name='x2', lb=0, vtype=GRB.INTEGER)

# Set the objective function
m.setObjective(400*x1 + 250*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(400*x1 + 200*x2 <= 25000, name='budget')
m.addConstr(x2 <= 0.5*x1, name='speaker_limit')

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.x}, x2 = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
