
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, ub=75, vtype=gurobi.GRB.INTEGER, name="televisions")
    x2 = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="speakers")

    # Objective function: Maximize 400*x1 + 250*x2
    model.setObjective(400*x1 + 250*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(400*x1 + 200*x2 <= 25000, name="budget_constraint")
    model.addConstr(x1 >= 20, name="min_televisions_constraint")
    model.addConstr(x2 <= 0.5*x1, name="speakers_vs_televisions_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Televisions = {x1.varValue}, Speakers = {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found")

solve_optimization_problem()
