
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("binder_production")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="one_inch_binders") # Number of one-inch binders
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="two_inch_binders") # Number of two-inch binders


# Set objective function
m.setObjective(1*x1 + 2*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 >= 60, "min_one_inch")
m.addConstr(x2 >= 70, "min_two_inch")
m.addConstr(x1 <= 150, "max_one_inch")
m.addConstr(x2 <= 160, "max_two_inch")
m.addConstr(x1 + x2 >= 200, "total_binders")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of one-inch binders: {x1.x}")
    print(f"Number of two-inch binders: {x2.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

