
from gurobipy import *

# Create a new model
m = Model("binder_production")

# Define variables
x1 = m.addVar(lb=60, ub=150, vtype=GRB.INTEGER, name="one_inch_binders")
x2 = m.addVar(lb=70, ub=160, vtype=GRB.INTEGER, name="two_inch_binders")

# Set the objective function
m.setObjective(1*x1 + 2*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 >= 200, "total_binders")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"One-inch binders: {x1.x}")
    print(f"Two-inch binders: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
