
import gurobipy as gp

# Create a new model
model = gp.Model("binder_production")

# Define the variables
x1 = model.addVar(lb=0, name="one_inch_binders")  # one-inch binders
x2 = model.addVar(lb=0, name="two_inch_binders")  # two-inch binders

# Objective function: maximize profit
model.setObjective(x1 + 2*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 >= 60, name="min_one_inch")
model.addConstr(x2 >= 70, name="min_two_inch")
model.addConstr(x1 <= 150, name="max_one_inch")
model.addConstr(x2 <= 160, name="max_two_inch")
model.addConstr(x1 + x2 >= 200, name="total_binders")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: one-inch binders = {x1.varValue}, two-inch binders = {x2.varValue}")
    print(f"Maximum profit: ${model.objVal}")
else:
    print("No optimal solution found.")
