
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("gardener_optimization")

# Create variables
lettuce = m.addVar(lb=0, name="lettuce")  # sqft of lettuce
tomatoes = m.addVar(lb=0, name="tomatoes") # sqft of tomatoes


# Set objective function
m.setObjective(2 * lettuce + 3 * tomatoes, GRB.MAXIMIZE)

# Add constraints
m.addConstr(lettuce + tomatoes <= 300, "space_constraint")
m.addConstr(5 * lettuce + 7 * tomatoes <= 2250, "bugs_spray_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"  Sqft of Lettuce: {lettuce.x}")
    print(f"  Sqft of Tomatoes: {tomatoes.x}")
    print(f"  Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

