
from gurobipy import *

# Create a new model
m = Model("Gardener_Problem")

# Define variables
x1 = m.addVar(lb=0, name="lettuce")
x2 = m.addVar(lb=0, name="tomatoes")

# Set the objective function
m.setObjective(2*x1 + 3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 300, "total_area")
m.addConstr(5*x1 + 7*x2 <= 255, "bug_spray")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Lettuce: {x1.x} sqft")
    print(f"Tomatoes: {x2.x} sqft")
    print(f"Total Profit: ${m.objVal}")
else:
    print("No optimal solution found.")
