
import gurobi

def solve_gardening_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='lettuce', lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name='tomatoes', lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: Maximize 2*x1 + 3*x2
    model.setObjective(2*x1 + 3*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 300, name='backyard_constraint')
    model.addConstr(5*x1 + 7*x2 <= 255, name='bug_spray_constraint')

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal sqft of lettuce: {x1.varValue}")
        print(f"Optimal sqft of tomatoes: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_gardening_problem()
