
import gurobipy as gp

# Create a new model
m = gp.Model("speaker_production")

# Create variables
regular_speakers = m.addVar(vtype=gp.GRB.CONTINUOUS, name="regular_speakers")
portable_speakers = m.addVar(vtype=gp.GRB.CONTINUOUS, name="portable_speakers")


# Set objective function
m.setObjective(40 * regular_speakers + 60 * portable_speakers, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(regular_speakers <= 120, "Team_A_capacity")
m.addConstr(portable_speakers <= 200, "Team_B_capacity")
m.addConstr(regular_speakers + portable_speakers <= 300, "Testing_machine_capacity")
m.addConstr(regular_speakers >= 0, "regular_speakers_nonnegative")  # Ensure non-negativity
m.addConstr(portable_speakers >= 0, "portable_speakers_nonnegative") # Ensure non-negativity

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Regular speakers: {regular_speakers.x}")
    print(f"Portable speakers: {portable_speakers.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

