
from gurobipy import *

# Create a new model
m = Model("Speaker_Production")

# Define variables
x1 = m.addVar(lb=0, name="regular_speakers")
x2 = m.addVar(lb=0, name="portable_speakers")

# Set the objective function
m.setObjective(40*x1 + 60*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 120, "Team_A_Capacity")
m.addConstr(x2 <= 200, "Team_B_Capacity")
m.addConstr(x1 + x2 <= 300, "Testing_Machine_Capacity")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular speakers: {x1.x}")
    print(f"Portable speakers: {x2.x}")
    print(f"Maximum profit: ${40*x1.x + 60*x2.x}")
else:
    print("No optimal solution found")
