
import gurobipy as gp

# Create a new model
model = gp.Model("Beta_Audio_Speaker_Production")

# Define the variables
x1 = model.addVar(lb=0, ub=120, name="regular_speakers")
x2 = model.addVar(lb=0, ub=200, name="portable_speakers")

# Objective function: Maximize profit
model.setObjective(40*x1 + 60*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 <= 120, name="team_a_capacity")
model.addConstr(x2 <= 200, name="team_b_capacity")
model.addConstr(x1 + x2 <= 300, name="testing_machine_capacity")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Regular Speakers: {x1.varValue}")
    print(f"Portable Speakers: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("No optimal solution found.")
