
import gurobipy as gp

# Create a new model
model = gp.Model("pottery_optimization")

# Create variables
mugs = model.addVar(vtype=gp.GRB.INTEGER, name="mugs")
bowls = model.addVar(vtype=gp.GRB.INTEGER, name="bowls")

# Set objective function
model.setObjective(10 * mugs + 15 * bowls, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20 * mugs + 30 * bowls <= 1200, "time_constraint")
model.addConstr(mugs + bowls <= 50, "clay_constraint")
model.addConstr(mugs >=0, "non_negativity_mugs")
model.addConstr(bowls >=0, "non_negativity_bowls")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of mugs to make: {mugs.x}")
    print(f"Number of bowls to make: {bowls.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

