
from gurobipy import *

# Create a new model
model = Model("Pottery_Problem")

# Define variables
x1 = model.addVar(vtype=GRB.INTEGER, name="mugs")
x2 = model.addVar(vtype=GRB.INTEGER, name="bowls")

# Set the objective function
model.setObjective(10*x1 + 15*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*x1 + 30*x2 <= 1200, "time_constraint")
model.addConstr(x1 + x2 <= 50, "clay_constraint")
model.addConstr(x1 >= 0, "non_neg_mugs")
model.addConstr(x2 >= 0, "non_neg_bowls")

# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of mugs: {x1.x}")
    print(f"Number of bowls: {x2.x}")
    print(f"Maximum profit: ${model.objVal}")
else:
    print("No optimal solution found")
