
import gurobi

def solve_porcelain_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="mugs", lb=0, ub=None, obj=10)
    x2 = model.addVar(name="bowls", lb=0, ub=None, obj=15)

    # Add constraints
    model.addConstr(x1 * 20 + x2 * 30 <= 1200, name="time_constraint")
    model.addConstr(x1 + x2 <= 50, name="clay_constraint")

    # Set the model objective
    model.setObjective(x1 * 10 + x2 * 15, gurobi.GRB.MAXIMIZE)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
        print(f"Optimal profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_porcelain_problem()
