
import gurobipy as gp

# Create a new model
m = gp.Model("construction_optimization")

# Create variables
bulldozers = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bulldozers")
forklifts = m.addVar(vtype=gp.GRB.CONTINUOUS, name="forklifts")

# Set objective function
m.setObjective(7000 * bulldozers + 6000 * forklifts, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * bulldozers + 2 * forklifts <= 600, "assembly_line_constraint")
m.addConstr(2 * bulldozers + 1.5 * forklifts <= 400, "qc_constraint")
m.addConstr(bulldozers >= 0, "bulldozers_nonnegative")
m.addConstr(forklifts >= 0, "forklifts_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Bulldozers: {bulldozers.x}")
    print(f"Number of Forklifts: {forklifts.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

