
from gurobipy import *

# Create a new model
m = Model("Construction_Company")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="bulldozers", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="forklifts", lb=0)

# Set the objective function
m.setObjective(7000*x1 + 6000*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 2*x2 <= 600, "assembly_line_time")
m.addConstr(2*x1 + 1.5*x2 <= 400, "qc_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of bulldozers: {x1.x}")
    print(f"Number of forklifts: {x2.x}")
    print(f"Total profit: ${7000*x1.x + 6000*x2.x:.2f}")
else:
    print("No optimal solution found")
