
import gurobipy as gp

# Create a new model
model = gp.Model("Bulldozers_and_Forklifts")

# Define the variables
x1 = model.addVar(name="bulldozers", lb=0, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="forklifts", lb=0, vtype=gp.GRB.INTEGER)

# Define the objective function
model.setObjective(7000*x1 + 6000*x2, gp.GRB.MAXIMIZE)

# Add the constraints
model.addConstr(3*x1 + 2*x2 <= 600, name="assembly_line_time")
model.addConstr(2*x1 + 1.5*x2 <= 400, name="qc_time")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {model.getVarByName('bulldozers').varValue} bulldozers, {model.getVarByName('forklifts').varValue} forklifts")
    print(f"Max Profit: ${model.objVal}")
else:
    print("No optimal solution found")
