
import gurobipy as gp

# Create a new model
m = gp.Model("Racket_Production")

# Create variables
tennis_rackets = m.addVar(vtype=gp.GRB.CONTINUOUS, name="tennis_rackets")  # x1
badminton_rackets = m.addVar(vtype=gp.GRB.CONTINUOUS, name="badminton_rackets")  # x2


# Set objective function
m.setObjective(20 * tennis_rackets + 17 * badminton_rackets, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(12 * tennis_rackets + 10 * badminton_rackets <= 3000, "molding_constraint")
m.addConstr(15 * tennis_rackets + 12 * badminton_rackets <= 3500, "stringing_constraint")
m.addConstr(tennis_rackets >= 0, "tennis_non_negativity")
m.addConstr(badminton_rackets >= 0, "badminton_non_negativity")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Tennis Rackets: {tennis_rackets.x}")
    print(f"Number of Badminton Rackets: {badminton_rackets.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

