
from gurobipy import *

# Create a new model
m = Model("Tennis_and_Badminton_Rackets")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="tennis_rackets")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="badminton_rackets")

# Set the objective function
m.setObjective(20*x1 + 17*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*x1 + 10*x2 <= 3000, "molding_time")
m.addConstr(15*x1 + 12*x2 <= 3500, "stringing_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of tennis rackets: {x1.x}")
    print(f"Number of badminton rackets: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
