
import gurobipy as gp

# Create a new model
model = gp.Model("TennisBadmintonRackets")

# Define variables
x1 = model.addVar(name="tennis_rackets", lb=0, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="badminton_rackets", lb=0, vtype=gp.GRB.INTEGER)

# Objective function: maximize profit
model.setObjective(20*x1 + 17*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(12*x1 + 10*x2 <= 3000, name="molding_time")
model.addConstr(15*x1 + 12*x2 <= 3500, name="stringing_time")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Max Profit: {model.objVal}")
else:
    print("No optimal solution found")
