
import gurobipy as gp

# Create a new model
m = gp.Model("costume_optimization")

# Create variables
police_costumes = m.addVar(vtype=gp.GRB.INTEGER, name="police_costumes")
fireman_costumes = m.addVar(vtype=gp.GRB.INTEGER, name="fireman_costumes")

# Set objective function
m.setObjective(10 * police_costumes + 12 * fireman_costumes, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * police_costumes + 12 * fireman_costumes <= 3000, "time_constraint")
m.addConstr(fireman_costumes >= 3 * police_costumes, "popularity_constraint")
m.addConstr(police_costumes >= 0, "non_negativity_police")
m.addConstr(fireman_costumes >= 0, "non_negativity_fireman")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of police officer costumes: {police_costumes.x}")
    print(f"Number of fireman costumes: {fireman_costumes.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

