
from gurobipy import *

# Create a model
m = Model("Costume_Optimization")

# Define variables
x1 = m.addVar(name="police_officer_costumes", vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name="fireman_costumes", vtype=GRB.INTEGER, lb=0)

# Objective function: Maximize profit
m.setObjective(10*x1 + 12*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(10*x1 + 12*x2 <= 3000, name="time_constraint")
m.addConstr(x2 >= 3*x1, name="demand_constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {int(x1.x)} units, {x2.varName} = {int(x2.x)} units")
    print(f"Maximum profit: ${10*x1.x + 12*x2.x}")
else:
    print("No optimal solution found.")
