
import gurobi

def solve_costume_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="police_officer_costumes")
    x2 = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="fireman_costumes")

    # Define the objective function
    model.setObjective(10*x1 + 12*x2, gurobi.GRB.MAXIMIZE)

    # Add the constraints
    model.addConstr(x2 >= 3*x1, name="fireman_police_ratio")
    model.addConstr(10*x1 + 12*x2 <= 3000, name="time_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution:")
        print(f"Police officer costumes: {x1.varValue}")
        print(f"Fireman costumes: {x2.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found")

solve_costume_problem()
