
import gurobipy as gp

# Create a new model
m = gp.Model("Amanda's Orchard")

# Create variables
apple_acres = m.addVar(name="apple_acres")
peach_acres = m.addVar(name="peach_acres")

# Set objective function
m.setObjective(15 * apple_acres + 25 * peach_acres, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(apple_acres + peach_acres <= 4000, "Total Acres")
m.addConstr(50 * apple_acres + 80 * peach_acres <= 30000, "Sapling Budget")
m.addConstr(3 * apple_acres + 5 * peach_acres <= 600, "Maintenance Hours")
m.addConstr(apple_acres >= 0, "Apple Acres Non-Negative")
m.addConstr(peach_acres >= 0, "Peach Acres Non-Negative")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Plant {apple_acres.x} acres of apple trees")
    print(f"Plant {peach_acres.x} acres of peach trees")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

