
from gurobipy import *

# Create a new model
m = Model("Amanda_Farm")

# Define the variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="apple_trees", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="peach_trees", lb=0)

# Set the objective function
m.setObjective(15*x1 + 25*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(50*x1 + 80*x2 <= 30000, "budget_constraint")
m.addConstr(3*x1 + 5*x2 <= 600, "maintenance_hours_constraint")
m.addConstr(x1 + x2 <= 4000, "total_land_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Acres of apple trees: {x1.x}")
    print(f"Acres of peach trees: {x2.x}")
    print(f"Maximum profit: ${15*x1.x + 25*x2.x:.2f}")
else:
    print("No optimal solution found.")
