
import gurobipy as gp

# Create a new model
m = gp.Model("Amanda_Trees")

# Define the variables
x1 = m.addVar(name="apple_trees", lb=0)
x2 = m.addVar(name="peach_trees", lb=0)

# Objective function
m.setObjective(15*x1 + 25*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 4000, name="land_constraint")
m.addConstr(50*x1 + 80*x2 <= 30000, name="budget_constraint")
m.addConstr(3*x1 + 5*x2 <= 600, name="maintenance_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Acres of apple trees: {x1.varValue}")
    print(f"Acres of peach trees: {x2.varValue}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found.")
