
import gurobipy as gp

# Create a new model
m = gp.Model("investment_optimization")

# Create variables
real_estate = m.addVar(name="real_estate")
pharmaceuticals = m.addVar(name="pharmaceuticals")

# Set objective function
m.setObjective(0.05 * real_estate + 0.10 * pharmaceuticals, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(real_estate + pharmaceuticals <= 300000, "total_investment")
m.addConstr(real_estate >= 0.30 * 300000, "min_real_estate")
m.addConstr(pharmaceuticals <= 0.35 * 300000, "max_pharmaceuticals")
m.addConstr(real_estate >= 0, "non_neg_real_estate")
m.addConstr(pharmaceuticals >= 0, "non_neg_pharmaceuticals")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment strategy:")
    print(f"Real Estate: ${real_estate.x:.2f}")
    print(f"Pharmaceuticals: ${pharmaceuticals.x:.2f}")
    print(f"Total Return: ${m.objVal:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

