
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Add variables
x1 = m.addVar(lb=0, name="Real_Estate")
x2 = m.addVar(lb=0, name="Pharmaceuticals")

# Set objective function
m.setObjective(0.05*x1 + 0.10*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 300000, "Total_Investment")
m.addConstr(x1 >= 90000, "Min_Real_Estate")
m.addConstr(x2 <= 105000, "Max_Pharma")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Amount invested in Real Estate: ${x1.x:.2f}")
    print(f"Amount invested in Pharmaceuticals: ${x2.x:.2f}")
    print(f"Total Return on Investment: ${(0.05*x1.x + 0.10*x2.x):.2f}")
else:
    print("No optimal solution found")
