
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='real_estate_investment', lb=0)
    x2 = model.addVar(name='pharmaceuticals_investment', lb=0)

    # Objective function
    model.setObjective(0.05 * x1 + 0.10 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 == 300000, name='total_investment')
    model.addConstr(x1 >= 90000, name='real_estate_min')
    model.addConstr(x2 <= 105000, name='pharmaceuticals_max')

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in real estate: ${x1.varValue}")
        print(f"Optimal investment in pharmaceuticals: ${x2.varValue}")
        print(f"Max return: ${0.05 * x1.varValue + 0.10 * x2.varValue}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
